@extends('admin.layout.page-app')
@section('page_title', __('label.audio_questions'))
@section('tab_title', __('label.audio_questions'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.audio_questions')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-9">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.audio_questions')}}</li>
                    </ol>
                </div>
                <div class="col-sm-3 d-flex align-items-center justify-content-between">
                    <a href="{{ route('admin.audioquestion.import.index') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('label.import_question')}}</a>
                    <a href="{{ route('admin.audioquestion.create') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('label.add_question')}}</a>
                </div>
            </div>

            <!-- Search & Table -->
            <div class="card custom-border-card">
                <div class="page-search">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-xl"></i></span>
                        </div>
                        <input type="text" id="input_search" class="form-control" placeholder="{{__('label.search')}}" aria-label="Search" aria-describedby="basic-addon1">
                    </div>
                </div>
                <div class="page-search mb-3">
                    <div class="sorting mr-2 w-25">
                        <label>{{__('label.sort_by')}}</label>
                        <select class="form-control" name="input_category" id="input_category">
                            <option value="0" selected>{{__('label.all_category')}}</option>
                            @for ($i = 0; $i < count($category); $i++)
                                <option value="{{ $category[$i]['id'] }}" {{ request('input_category') == $category[$i]['id'] ? 'selected' : ''}}>
                                    {{ $category[$i]['name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="sorting mr-2 w-25">
                        <select class="form-control" name="input_skill" id="input_skill">
                            <option value="0" selected>{{__('label.all_skill')}}</option>
                            @for ($i = 0; $i < count($skill); $i++)
                                <option value="{{ $skill[$i]['id'] }}" {{ request('input_skill') == $skill[$i]['id'] ? 'selected' : ''}}>
                                    {{ $skill[$i]['name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="sorting mr-2 w-25">
                        <select class="form-control" name="input_classification" id="input_classification">
                            <option value="0" selected>{{__('label.all_classification')}}</option>
                            @for ($i = 0; $i < count($classification); $i++)
                                <option value="{{ $classification[$i]['id'] }}" {{ request('input_classification') == $classification[$i]['id'] ? 'selected' : ''}}>
                                    {{ $classification[$i]['name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="sorting mr-2 w-25">
                        <select class="form-control" name="input_level" id="input_level">
                            <option value="0" selected>{{__('label.all_level')}}</option>
                            @for ($i = 0; $i < count($level); $i++)
                                <option value="{{ $level[$i]['id'] }}" {{ request('input_level') == $level[$i]['id'] ? 'selected' : ''}}>
                                    {{ $level[$i]['name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped text-center table-bordered" id="datatable">
                        <thead>
                            <tr>
                                <th>{{__('label.#')}}</th>
                                <th>{{__('label.image')}}</th>
                                <th>{{__('label.basic_info')}}</th>
                                <th>{{__('label.question')}}</th>
                                <th>{{__('label.option')}}</th>
                                <th>{{__('label.status')}}</th>
                                <th>{{__('label.action')}}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>

            <!-- Audio Modal -->
            <div class="modal fade" id="audioModal" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-md">
                    <div class="modal-content">
                        <div class="modal-body">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true" class="text-dark">&times;</span>
                            </button>
                            <audio id="theAudio" controls preload="none" controlsList="nodownload noplaybackrate" disablePictureInPicture class="w-100">
                                <source id="audioSource" src="" type="audio/mpeg">
                            </audio>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        $(document).ready(function() {

            // Audio Model
            const audio = document.getElementById('theAudio');
            $(document).on('click', '.audio', function () {
                const audioURL = $(this).data('audio');
                $('#audioSource').attr('src', audioURL);
                audio.load();
            });
            $("#audioModal .close").click(function() {
                audio.pause();
                audio.currentTime = 0;
                $('#audioSource').attr('src', ''); // clear audio source
            });
            $('#audioModal').on('contextmenu', function (e) {
                e.preventDefault();
            });

            // Table
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax:
                    {
                    url: "{{ route('admin.audioquestion.index') }}",
                    data: function(d){
                        d.input_search = $('#input_search').val();
                        d.input_category = $('#input_category').val();
                        d.input_skill = $('#input_skill').val();
                        d.input_classification = $('#input_classification').val();
                        d.input_level = $('#input_level').val();
                    },
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                    {
                        data: 'image',
                        name: 'image',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, full, meta) {
                            return "<a href='" + data + "' target='_blank'><img src='" + data + "' class='img-thumbnail' style='height:60px; width:60px'></a>";
                        },
                    },
                    {
                        data: 'basic_info',
                        name: 'basic_info',
                        width: '18%',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `<div style="text-align: left; font-size: 14px;">
                                        <strong>{{__('label.category')}} : </strong> ${row.category?.name || '-'}<br>
                                        <strong>{{__('label.skill')}} : </strong> ${row.skill?.name || '-'}<br>
                                        <strong>{{__('label.classification')}} : </strong> ${row.classification?.name || '-'}<br>
                                        <strong>{{__('label.level')}} : </strong> ${row.level?.name || '-'}<br>
                                    </div>`; 
                        }
                    },
                    {
                        data: 'question',
                        name: 'question',
                        width: '30%',
                        render: function(data) {
                            return data ? '<div style="text-align: left; font-size: 14px;">' + data + '</div>' : "-";
                        }
                    },
                    {
                        data: 'option',
                        name: 'option',
                        width: '25%',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            const correct = row.correct_answer;

                            const optionStyle = (key) => correct === key ? 'class="green-color"' : '';
                            return `
                                <div style="text-align: left;">
                                    <div ${optionStyle(1)}><strong>{{__('label.a')}} : </strong>${row.option_a || '-'}</div>
                                    <div ${optionStyle(2)}><strong>{{__('label.b')}} : </strong>${row.option_b || '-'}</div>
                                    <div ${optionStyle(3)}><strong>{{__('label.c')}} : </strong>${row.option_c || '-'}</div>
                                    <div ${optionStyle(4)}><strong>{{__('label.d')}} : </strong>${row.option_d || '-'}</div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });
            $('#input_category, #input_skill, #input_classification, #input_level').change(function(){
                table.draw();
            });
            $('#input_search').keyup(function(){
                table.draw();
            });
        });

        function change_status(id) {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                $("#dvloader").show();
                var url = `{{ route('admin.audioquestion.show', '') }}/${id}`;

                $.ajax({
                    type: "GET",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(resp) {
                        $("#dvloader").hide();

                        if (resp.status == 200) {
                            if (resp.status_code == 1) {
                                $('#' + id).text('{{__("label.show")}}').removeClass('hide-btn').addClass('show-btn');
                            } else {
                                $('#' + id).text('{{__("label.hide")}}').removeClass('show-btn').addClass('hide-btn');
                            }
                            toastr.success(resp.success);
                        } else {
                            toastr.error(resp.errors);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        };
    </script>
@endsection